using System;
using System.IO;
using System.Diagnostics;
using System.Security.Cryptography;

using Bertaccini.Utils;

using Team_Project.Exceptions;
using Team_Project.PersistencyManagers.Protocols;
using Team_Project.PersistencyManagers.Storages;

namespace Team_Project.Elements
{
	public class FileElement: IProjectElement
	{
		public static readonly string Suff = ".tp";
		protected string name;
		protected string path;
		protected Stream data;
		private bool reading;
		protected byte[] hash = new byte[20];
		protected DateTime upTime;
		protected string uploaderID;
		


		public FileElement(string proj,string path,string name)
		{
			Trace.WriteLine("FileElement instance created");
			this.name = name;
			this.path = path;
			project = proj;
		}

		#region File data
		public byte[] Hash
		{
			get{return hash;}
			set{hash = value;}
		}
		public DateTime UploadTime
		{
			get{return upTime;}
			set{upTime = value;}
		}

		public string UploaderID
		{
			get{return uploaderID;}
			set{uploaderID = value;}
		}


		public void SetRawData(Stream source)
		{
			SHA1Managed HashP = new SHA1Managed();
			HashP.Initialize();
			if(!Directory.Exists("C:\\Temp\\" + Location))
				Directory.CreateDirectory("C:\\Temp\\" + Location);
			string tempFN = "C:\\Temp\\"+ FullName;
			FileStream tempF = File.OpenWrite(tempFN);
			int i;
			while((i = source.ReadByte()) != -1)
				tempF.WriteByte((byte)i);
			tempF.Close();
			tempF = File.OpenRead(tempFN);
			Hash = HashP.ComputeHash(tempF);
			tempF.Seek(0,SeekOrigin.Begin);
			/*DoubleStream str = new DoubleStream(tempF);
			str.Write(Hash,0,20);
			StoreDateTime(str,UploadTime);
			StoreString(str,UploaderID);
			str.Seek(0,SeekOrigin.Begin);*/
			data = tempF;
			//return str;
		}
		#endregion
		#region Store utils
		protected static DateTime ParseDateTime(Stream data)
		{
			short y1 = (short)data.ReadByte();
			short y2 = (short)data.ReadByte();
			int y = y1*100+y2;
			short mnt = (short)data.ReadByte();
			short d = (short)data.ReadByte();
			short h = (short)data.ReadByte();
			short min = (short)data.ReadByte();
			short s = (short)data.ReadByte();
			return new DateTime(y,mnt,d,h,min,s,0);
		}
		
		protected static void StoreDateTime(Stream data,DateTime dt)
		{
			int Fb = dt.Year/100;
			data.WriteByte((byte)Fb);
			data.WriteByte((byte)(dt.Year - Fb*100));
			data.WriteByte((byte)dt.Month);
			data.WriteByte((byte)dt.Day);
			data.WriteByte((byte)dt.Hour);
			data.WriteByte((byte)dt.Minute);
			data.WriteByte((byte)dt.Second);
		}

		protected static void StoreString(Stream data,string s)
		{
			foreach(char c in s)
			{
				data.WriteByte((byte)c);
			}
			data.WriteByte((byte)13);
			data.WriteByte((byte)10);
		}

		#endregion

		#region IProjectElement Members

		public override string Suffix
		{
			get{return Suff;}
		}
		
		public override string FullName
		{
			get{return path + "\\" + name;}
		}

		public override string Name
		{
			get{return name;}
		}

		public override string Location
		{
			get{return path;}
			set{
				path = value;
			}
		}

		public override Stream DataInput
		{
			set
			{
#if DEBUG
				if (data != null) throw new Exception("Data set more then once");
#endif
				data = value;
				reading = false;
				data.Read(hash,0,20);
				upTime = ParseDateTime(data);
				uploaderID = Bertaccini.Utils.SRead.ReadLine(data);
			}
		}

		public override void DestroyFrom(Team_Project.PersistencyManagers.Storages.IStorage src)
		{
			this.Dispose();
			src.Delete(Location,Name+Suff);
		}

		public void BindForCopy(FileElement fe)
		{
			fe.data = this.data;
			fe.hash = this.hash;
			fe.UploaderID = this.UploaderID;
			fe.UploadTime = this.UploadTime;
		}

		public override void WriteTo(Stream destStr)
		{
			if(data.CanSeek)
				data.Seek(0,SeekOrigin.Begin);
			int i;
			while((i = data.ReadByte()) != -1)
			{
				if(!reading || !Globals.Instance.Mutexes.AreWritersWaiting(project,Location+ "||" + this.GetType().Name,name))
					destStr.WriteByte((byte)i);
				else
				{
					destStr.Close();
					Trace.WriteLine("File-WriteTo: exception.Writers?="+
						Globals.Instance.Mutexes.AreWritersWaiting(project,Location+ "||" + this.GetType().Name,name).ToString()
						+" reading="+reading.ToString());
					throw new ConcurrencyException("Another user is updating file " + FullName);
				}
			}
		}


		public override void WriteTo(Team_Project.PersistencyManagers.Storages.IStorage dest)
		{
			//data.Seek(0,SeekOrigin.Begin);
			long pos = data.Position;
			Trace.WriteLine(this.FullName + " opening stream for writing");
			using(Stream destStr = dest.OpenWrite(Location,Name+Suff))
			{
				destStr.Write(hash,0,20);
				StoreDateTime(destStr,UploadTime);
				StoreString(destStr,uploaderID);
				WriteTo(destStr);
				Trace.WriteLine(this.FullName + " closing stream used for writing");
			}
			data.Position = pos;
		}

		public override void LoadFrom(Team_Project.PersistencyManagers.Storages.IStorage src)
		{
			reading = true;
			Trace.WriteLine(this.FullName + " opening stream for reading");
			DataInput = src.OpenRead(Location,Name+Suff);
		}
		#endregion

		#region IDisposable Members

		public override void Dispose()
		{
			try
			{
				if(data != null)
				{
					Trace.WriteLine(this.FullName + " closing stream");
					data.Close();
				}
			}
			catch{}
		}

		#endregion
	}
}
